/*---------------------------------------------------------------------------*\

    FILE....: PLAYWAV.CPP
    TYPE....: C++ Console program
    AUTHOR..: David Rowe
    DATE....: 10/5/01

    This program plays a wave file.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "threads.h"

#include "../src/vpbapi.h"
#include "../src/verbose.h"

void *event_thread(void *pv);
int arg_exists(int argc, char *argv[], char *arg);
int finish;

int main(int argc, char * argv[])
{
	int	        h, arg;
	pthread_t       ev_thread;
	int             ch_num, ports_per_card;

	if (argc < 3) {
	       printf("usage: playwav WaveFile ChNum[1..] [--recgain GdB]");
	       printf(" [--playgain GdB] ");
	       printf(" [--rec WaveFile] ");
	       printf(" [--dial Number] ");
	       printf("\n");
	       exit(0);
	}

	vpb_seterrormode(VPB_DEVELOPMENT);

	h = vpb_open(1,1);
	ports_per_card = vpb_get_ports_per_card();
	vpb_close(h);

	ch_num = atoi(argv[2]);
	h = vpb_open(1 + ((ch_num-1)/ports_per_card),1+ ((ch_num-1)%ports_per_card));

	finish = 0;
	pthread_create(&ev_thread, NULL, event_thread, NULL);

	// optionally set record gain - used for DTMF cut thru testing
	if ((arg = arg_exists(argc, argv, "--recgain")) != 0) {
		 vpb_record_set_gain(h, (float)atof(argv[arg+1]));	
		 printf("record gain set to %f\n", atof(argv[arg+1]));
	}
	// optionally set play gain - used for gain testing
	if ((arg = arg_exists(argc, argv, "--playgain")) != 0) {
		 vpb_play_set_gain(h, (float)atof(argv[arg+1]));	
		 printf("play gain set to %f\n", atof(argv[arg+1]));
	}

	// optionally record at the same time - used for DTMF cut thru testing
	if ((arg = arg_exists(argc, argv, "--rec")) != 0) {
		 vpb_record_file_async(h, argv[arg+1], VPB_LINEAR);
		 printf("recording to %s\n", argv[arg+1]);
	}

	// optionally dial at the same time
	if ((arg = arg_exists(argc, argv, "--dial")) != 0) {
		 vpb_dial_async(h, argv[arg+1]);
	}

	vpb_sethook_sync(h, VPB_OFFHOOK);
	vpb_play_file_sync(h, argv[1]);
	vpb_record_terminate(h);
	vpb_sethook_sync(h, VPB_ONHOOK);

	finish = 1;
	while(finish)
		vpb_sleep(20);

	vpb_close(h);

	return 0;
}

void *event_thread(void *pv) {
	char	  s[VPB_MAX_STR];
        VPB_EVENT e;

	do {
		// check for events from VPB

		while(vpb_get_event_async(&e) == VPB_OK) {
			vpb_translate_event(&e, s);
			printf(s);
		}

		vpb_sleep(10);
	} while(!finish);

	finish = 0;

	return NULL;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}


